Attribute VB_Name = "m_TOC"
Option Explicit

Sub Table_Of_Contents()
'Create/Update a Table of Contents sheet in the active workbook.

Dim ws As Worksheet
Dim wsTOC As Worksheet
Dim sTOCName As String
Dim bExists As Boolean
Dim i As Long

  Application.ScreenUpdating = False
  
  'Set variables
  sTOCName = "Table of Contents"
  Const bSkipHidden As Boolean = False 'Change this to True to NOT list hidden sheets
  Const sTitle As String = "B2"
  Const sHeader As String = "B4"
  i = 1
  
  'Check if TOC sheet exists or add it
  With ActiveWorkbook
    If SheetExists(sTOCName) Then
      Set wsTOC = .Worksheets(sTOCName)
    Else
      Set wsTOC = .Worksheets.Add(Before:=.Sheets(1))
      wsTOC.Name = sTOCName
    End If
  End With
  
  
  'Clear Cells
  wsTOC.Cells.Clear
  
  'Title
  With wsTOC.Range(sTitle)
    .Value = "Table of Contents"
    .Font.Bold = True
    .Font.Size = .Font.Size + 2
    
    'List header
    .Offset(2).Value = "#"
    .Offset(2, 1).Value = "Sheet Name"
    .Offset(2).Resize(1, 2).Font.Bold = True
  End With
  
  'Create TOC list
  With wsTOC.Range(sHeader)
  
    'Create list
    For Each ws In ActiveWorkbook.Worksheets
        'Skip TOC sheet
        If ws.Name <> wsTOC.Name Then
          'Skipping hidden sheets can be toggled in the variable above
          If bSkipHidden Or ws.Visible = xlSheetVisible Then
            .Offset(i).Value = i
            wsTOC.Hyperlinks.Add Anchor:=.Offset(i, 1), _
                                  Address:="", _
                                  SubAddress:="'" & ws.Name & "'!A1", _
                                  TextToDisplay:=ws.Name
            i = i + 1
          End If
        End If
    Next ws
    
    'Turn filters off
    If wsTOC.AutoFilterMode Then
      wsTOC.Cells.AutoFilter
    End If
    
    'Apply filters
    .Resize(i, 2).AutoFilter
    
    'Formatting
    .Font.Italic = True
    
    'AutoFit
    .Resize(i, 2).Columns.AutoFit
    
    'Gridlines
    ActiveWindow.DisplayGridlines = False
  
  End With
  
  Application.ScreenUpdating = True
  
End Sub

Function SheetExists(WorksheetName As String) As Boolean

    On Error Resume Next
    SheetExists = (Sheets(WorksheetName).Name <> "")
    On Error GoTo 0

End Function

